<?php

namespace Ignite\Activity\Facades;

use Ignite\Activity\Contracts\Schema as SchemaContract;
use Illuminate\Support\Facades\Facade;

/**
 * Schema Facade
 *
 * @method void boot()
 * @method SchemaContract type(string $code)
 * @see \Ignite\Activity\Domain\Form\Manager
 * @example Schema::boot()
 * @example Schema::type('claims')->getModelClass()
 * @example Schema::type('claims')->newModelBuilder()
 * @example Schema::type('claims')->newModelInstance()
 * @example Schema::type('claims')->states()
 * @example Schema::type('claims')->transitions()
 * @example Schema::type('claims')->statuses()
 * @example Schema::type('claims')->initialStatus()
 * @example Schema::type('claims')->fields()
 */
class Schema extends Facade
{
    /**
     * Replace the bound instance with a fake.
     *
     * @todo Write a fake implementation to assist during testing
     * @return \Ignite\Activity\Domain\Form\SchemaFake
     */
//    public static function fake()
//    {
//        static::swap(new \Ignite\Activity\Domain\Schema\SchemaFake());
//    }

    /**
     * Get the registered name of the component.
     *
     * @return string
     */
    protected static function getFacadeAccessor()
    {
        return 'schema';
    }
}
