<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateActivityOfferRuleTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('activity_offer_rule', function (Blueprint $table) {
            $table->id();
            $table->foreignId('rule_id')->constrained('activity_rule');
            $table->foreignId('offer_id')->constrained('activity_offer');
            $table->unsignedBigInteger('sequence')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('activity_rule');
    }
}
