<?php

namespace Ignite\Activity\Traits;

use Illuminate\Support\Arr;

trait MetableTrait
{
    /**
     * Get or set a value in the `meta` field data.
     *
     * @param string $key
     * @param mixed $default
     *
     * @return mixed
     */
    public function meta(string $key, $default = null)
    {
        return Arr::get($this->meta, $key, $default);
    }

    /**
     * Get all data except the provided keys.
     *
     * @param  array $keys
     *
     * @return array
     */
    public function metaExcept(...$keys)
    {
        return Arr::except($this->meta, $keys);
    }

    /**
     * Get all data except the provided keys.
     *
     * @param  array $keys
     *
     * @return array
     */
    public function metaOnly($keys = [])
    {
        return Arr::only($this->meta, $keys);
    }

    /**
     * Set a value in the `meta` field data.
     *
     * @param string $key
     * @param mixed $value
     *
     * @return mixed
     */
    public function metaSet(string $key, $value = null)
    {
        $meta = (array) $this->meta;
        Arr::set($meta, $key, $value);
        $this->meta = $meta;

        return $this;
    }

    /**
     * Set a value in the `meta` field data and save to storage.
     *
     * @param string $key
     * @param mixed $value
     *
     * @return bool
     */
    public function metaSave(string $key, $value)
    {
        return $this->metaSet($key, $value)->save();
    }
}
