<?php

namespace Ignite\Activity\Http\Forms;

use Ignite\Core\Models\Form\Form;
use Illuminate\Http\UploadedFile;

class OfferTranslationForm extends Form
{
    public function buildForm()
    {
        $readonly = $this->getData('readonly', false);

        $this->setFormOptions(['wrapper' => [
            'id' => "tab-{$this->language}",
            'class' => 'tab-pane',
        ]]);

        $this->add('label', 'text', $this->field([
            'label' => 'Label',
            'attr' => [
                'readonly' => $readonly,
                'disabled' => $readonly,
            ],
        ]));

        $this->add('description', 'textarea', $this->field([
            'label' => 'Description',
            'attr' => [
                'readonly' => $readonly,
                'disabled' => $readonly,
            ],
        ]));

        $this->add('banner', 'file', $this->field([
            'label' => 'Banner',
            'path' => 'offers',
            'disk' => 'public',
            'attr' => [
                'readonly' => $readonly,
                'disabled' => $readonly,
            ],
            'store_as' => function (UploadedFile $file) {
                return $file->getClientOriginalName();
            },
        ]));
    }

    /**
     * Prepare the field data so it remains consistent.
     *
     * @param array $data
     *
     * @return array
     */
    protected function field($data)
    {
        return array_merge_recursive([
            'label_attr' => [
                'class' => 'control-label col-sm-3'
            ],
            'form_horizontal' => true,
        ], $data);
    }
}
