<?php

namespace Ignite\Activity\Http\Controllers\Admin;

use Exception;
use Ignite\Activity\Contracts\ActivitySubmissionRepository;
use Ignite\Activity\Entities\Activity;
use Ignite\Activity\Entities\Offer;
use Ignite\Activity\Entities\Submission;
use Ignite\Activity\Entities\Type;
use Ignite\Core\Http\Controllers\Controller;
use Ignite\Packages\Presenter\Exceptions\PresenterException;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class SubmissionStatusController extends Controller
{
    /**
     * @var ActivitySubmissionRepository
     */
    protected ActivitySubmissionRepository $repository;

    /**
     * SubmissionStatusesController constructor.
     *
     * @param ActivitySubmissionRepository $repository
     */
    public function __construct(ActivitySubmissionRepository $repository)
    {
        $this->repository = $repository;
    }

    /**
     * Update the activity status value.
     *
     * @param Type $type
     * @param Offer $offer
     * @param Activity $activity
     * @param Submission $submission
     * @param Request $request
     *
     * @return Renderable|RedirectResponse
     * @throws PresenterException
     */
    public function __invoke(Type $type, Offer $offer, Activity $activity, Submission $submission, Request $request)
    {
        $from = $request->get('from');
        $to = $request->get('to');

        if (!$to) {
            $this->flashError("Transitioning to an empty state is not allowed.");
            return redirect()->to($submission->present()->editUrl('status'));
        }

        $submissionIds = explode(',', $request->get('submissions'));
        $notes = $request->get('notes');

        app('db')->beginTransaction();

        try {
            foreach ($submissionIds as $id) {
                $this->repository->changeStatus($id, $to, $notes);
            }

            app('db')->commit();

            $this->flashSuccess("Updated from {$from} to {$to}.");
        } catch (Exception $exception) {
            app('db')->rollBack();

            logger()->critical($exception->getMessage(), compact('exception'));

            $this->flashError('An error has occurred. IT have been notified. Statuses have not been changed.');
        }

        return redirect()->to($submission->present()->editUrl('status'));
    }
}
