<?php

namespace Ignite\Activity\Events;

use Ignite\Activity\Domain\Rules\RuleManager;
use Ignite\Activity\Entities\Activity;
use Ignite\Activity\Entities\Submission;
use Illuminate\Support\Collection;

class ActivitySubmissionRulesProcessing
{
    /**
     * @var RuleManager
     */
    public $ruleManager;

    /**
     * @var Activity
     */
    public $activity;

    /**
     * @var Collection
     */
    public $rules;

    /**
     * @var Submission
     */
    public $submission;

    /**
     * ActivitySubmissionRulesProcessing constructor.
     *
     * @param RuleManager $ruleManager
     * @param Activity $activity
     * @param Submission $submission
     * @param Collection $rules
     */
    public function __construct(RuleManager $ruleManager, Activity $activity, Submission $submission, Collection $rules)
    {
        $this->ruleManager = $ruleManager;
        $this->activity = $activity;
        $this->submission = $submission;
        $this->rules = $rules;
    }
}
