<?php

namespace Ignite\Activity\Contracts;

use Ignite\Activity\Domain\Submissions\ActivitySubmissionException;
use Ignite\Activity\Entities\Activity;
use Ignite\Activity\Entities\Offer;
use Ignite\Core\Entities\User;

interface ActivitySubmissionRepository
{
    /**
     * Create a new activity submission.
     *
     * @param Offer $offer
     * @param array $data
     * @param User $submitter
     *
     * @return Activity
     * @throws ActivitySubmissionException
     */
    public function create(Offer $offer, array $data, User $submitter);

    /**
     * Create an existing activity submission.
     *
     * @param int $submissionId
     * @param array $data
     * @param User $submitter
     *
     * @return Activity
     * @throws ActivitySubmissionException
     */
    public function update($submissionId, array $data, User $submitter);

    /**
     * Change the status of the submission.
     *
     * @param int $submissionId
     * @param string $status
     * @param string|null $notes
     * @param User|null $changedByUser
     *
     * @return bool
     * @throws ActivitySubmissionException
     */
    public function changeStatus($submissionId, string $status, string $notes = null, User $changedByUser = null);

    /**
     * Change the value of the submission.
     *
     * @param int $submissionId
     * @param int|float $value
     * @param User|null $changedByUser
     * @param bool $isManual
     *
     * @return bool
     * @throws ActivitySubmissionException
     */
    public function changeValue($submissionId, $value, User $changedByUser = null, bool $isManual = false);
}