@if ($ruleLog && !empty($logs) && $ruleLog->created_at)
<div class="timeline-container">
    <h4 class="card-title">{{ __('Rule Log') }}</h4>
    <hr />
    <ul class="timeline">
        <li class="time-label">
            <span class="bg-white" style="border: 3px solid #dadada;">{{ $ruleLog->created_at->format('F jS, Y') }}</span>
        </li>
        @foreach ($logs as $log)
            <li>
                @if ($log['applied'] && $log['processed'])
                    <i class="fa fa-check bg-green" data-toggle="tooltip" data-placement="top" data-title="The rule has been processed and applied."></i>
                @elseif (! $log['applied'] && $log['processed'])
                    <i class="fa fa-times bg-red" data-toggle="tooltip" data-placement="top" data-title="The rule has been processed but not applied."></i>
                @elseif (! $log['processed'])
                    <i class="fa fa-pause-circle bg-yellow" data-toggle="tooltip" data-placement="top" data-title="The rule has not been processed."></i>
                @endif
                <div class="timeline-item">
                    <time datetime="{{ $ruleLog->created_at->format('Y-m-d H:i:s') }}" class="time" title="{{ $ruleLog->created_at->diffForHumans() }}">
                        <i class="fa fa-clock-o"></i> {{ $ruleLog->created_at->format('g:ia') }}
                    </time>
                    <h4 class="timeline-header" title="{{ $log['rule_label'] }}">{{ ucwords(implode(' ', preg_split('/(?=[A-Z])/', $log['rule_label']))) }}</h4>
                    <div class="timeline-body">
                        @if (! empty($log['rule_description']))<p>{{ $log['rule_description'] }}</p>@endif
                        @if (! empty($log['messages']))
                        <div class="well mb-0">
                            <ul class="list-unstyled">
                                @foreach ($log['messages'] as $type => $messages)
                                    @foreach ($messages as $message)
                                        @php
                                            $markdown = new Parsedown();
                                            $markdown->setSafeMode(true);
                                            $markdown->setMarkupEscaped(false);
                                            $markdown->setUrlsLinked(true);
                                            $markdown->setBreaksEnabled(false);
                                            $message = $markdown->line($message);
                                        @endphp
                                        @if ($type === 'info')
                                            <li><span class="label label-default">{{ $type }}</span> {!! $message !!}</li>
                                        @elseif ($type === 'error')
                                            <li><span class="label label-danger">{{ $type }}</span> {!! $message !!}</li>
                                        @endif
                                    @endforeach
                                @endforeach
                            </ul>
                        </div>
                        @endif
                        <p class="text-right">
                            @if ($log['applied'])
                                <strong class="label label-default ml-1">{{ __('Applied') }}</strong>
                            @else
                                <strong class="label label-default ml-1">{{ __('Not Applied') }}</strong>
                            @endif

                            @if ($log['processed'])
                                <strong class="label label-default ml-1">{{ __('Processed') }}</strong>
                            @else
                                <strong class="label label-default ml-1">{{ __('Not Processed') }}</strong>
                            @endif

                            @if ($log['processed'] && ! $log['propagated'])
                                <strong class="label label-warning ml-1">{{ __('Stopped Propagation') }}</strong>
                            @endif

                            @if ($log['applied'] && $log['changes_value'])
                                <strong class="label label-info ml-1">{{ __('Changes Value') }}: {{ number_format($log['value'], 2) }}</strong>
                            @endif
                        </p>
                    </div>
                </div>
            </li>
        @endforeach
        <li>
            <i class="fa fa-clock-o bg-gray"></i>
        </li>
    </ul>
</div>
@endif