@php $cnt = 0; @endphp
<div id="activity-statuses-by-type" class="box box-primary activity-status" style="display: none">
    <div class="box-header with-border">
        <h3 class="box-title">Activity Statuses by Type</h3>
    </div>
    <div class="box-body with-border">
        <p style="margin-bottom: 0;">
            <strong>Required CSV Columns</strong><br>
                {{ implode(', ', config('activity.import.types.activity_status.columns')) }}
        </p>
    </div>
    <hr style="margin: 0 10px;">
    @foreach($activityTypes as $type)
        <div class="box-body with-border">
            <p style="margin-bottom: 0;">
                <strong>{{ $type->label }}</strong><br>
                @if(isset($activityTypeStatuses[$type->code]))
                    {{ implode(', ', $activityTypeStatuses[$type->code]) }}
                @endif
            </p>
        </div>
        @if($cnt > 0 && $cnt != count($activityTypes))
            <hr style="margin: 0 10px;">
        @endif
        @php($cnt++)
    @endforeach
</div>

@push('js')
    <script type="text/javascript">
        $('#import-type').on('change', function() {
            let type = this.value;

            $('#activity-statuses-by-type').hide();
            if (type.endsWith('ActivityStatusImporter')) {
                $('#activity-statuses-by-type').show();
            }
        })
    </script>
@endpush
