<?php

namespace Ignite\Activity\Presenters;

use Ignite\Packages\Presenter\Presenter;

/**
 * Class Submission
 *
 * @property \Ignite\Activity\Entities\Submission $entity
 */
class Submission extends Presenter
{
    /**
     * The url to the edit screen.
     *
     * @param string $section
     *
     * @return string
     */
    public function editUrl(string $section = '')
    {
        return route('admin.activity.edit', [
            'type' => $this->entity->offer->type->code,
            'offer' => $this->entity->offer->code,
            'activity' => $this->entity->activity->getKey(),
            'submission' => $this->entity->getKey(),
            'section' => $section
        ]);
    }

    /**
     * The url to change the status.
     *
     * @return string
     */
    public function changeStatusUrl()
    {
        return route('admin.activity.status.update', [
            'type' => $this->entity->offer->type->code,
            'offer' => $this->entity->offer->code,
            'activity' => $this->entity->activity->getKey(),
            'submission' => $this->entity->getKey(),
        ]);
    }

    /**
     * The formatted value of the submission.
     *
     * @return string
     */
    public function value()
    {
        return number_format($this->entity->value, 2);
    }

}
