<?php

/** @var \Illuminate\Database\Eloquent\Factory $factory */

use Faker\Generator as Faker;
use Ignite\Activity\Entities\Offer;
use Ignite\Activity\Entities\Type;
use Illuminate\Support\Str;

$factory->define(Offer::class, function (Faker $faker) {
    return [
        'type_id' => factory(Type::class),
        'status' => 1,
        'label' => $label = $faker->unique()->words(4, true),
        'code' => Str::slug($label, '-'),
        'related_name' => Str::studly($label),
        'is_redeemable' => true,
        'sequence' => $faker->unique()->numberBetween(1, 100),
        'meta' => [],
        'translations' => []
    ];
});
