<?php

// -----

Route::prefix('activity')->middleware('auth')->group(function () {
    /* TODO Make the middlewares explicit per route/function and by frontend (without `.admin.`) */
    Route::get('/{type:code}', 'ActivityTypeController@index')->name('activity.index')->middleware('can:activity.browse');
    Route::get('/{type:code}/{offer:code}', 'ActivityTypeController@create')->name('activity.create')->middleware('can:activity.browse');
    Route::post('/{type:code}/{offer:code}', 'ActivityTypeController@store')->name('activity.store')->middleware('can:activity.browse');
    Route::get('/{type:code}/{offer:code}/{activity:id}', 'ActivityTypeController@show')->name('activity.show')->middleware('can:activity.browse');
});

// -----

Route::prefix('admin/activity')->namespace('Admin')->middleware('auth')->group(function () {
    /* TODO Make the middlewares explicit per route/function and by backend (with `.admin.`) */
    // Activity Offers Controller
    Route::any('{type:code}/offers', 'OfferController@index')->name('admin.offer.index')->middleware('can:activity.offer.browse');
    Route::post('{type:code}/offers/export', 'OfferController@index')->name('admin.offer.index.export')->middleware('can:activity.offer.browse');
    Route::get('{type:code}/offers/{offer:code}/edit', 'OfferController@edit')->name('admin.offer.edit')->middleware('can:activity.offer.update');
    Route::post('{type:code}/offers/{offer:code}/update', 'OfferController@update')->name('admin.offer.update')->middleware('can:activity.offer.update');

    // -----

    /* TODO Either finish this out or implement a notification system in core */
    // Activity Notifications Controller
//    Route::any('{type:code}/notifications', 'NotificationController@index')->name('admin.notification.index');
//    Route::post('{type:code}/notifications/export', 'NotificationController@index')->name('admin.notification.index.export');
//    Route::get('{type:code}/notifications/{notification}/edit', 'NotificationController@edit')->name('admin.notification.edit');
//    Route::post('{type:code}/notifications/{notification}/update', 'NotificationController@update')->name('admin.notification.update');

    // Activity Controller
    Route::any('{type:code}/submissions/{offer:code}', 'SubmissionController@index')->name('admin.activity.index')->middleware('can:activity.submission.all.browse');
    Route::post('{type:code}/submissions/{offer:code}/export', 'SubmissionController@index')->name('admin.activity.index.export')->middleware('can:activity.submission.all.browse');
    Route::get('{type:code}/submissions/{offer:code}/create', 'SubmissionController@create')->name('admin.activity.create')->middleware('can:activity.submission.all.create');
    Route::post('{type:code}/submissions/{offer:code}/create', 'SubmissionController@store')->name('admin.activity.store')->middleware('can:activity.submission.all.create');
    Route::get('{type:code}/submissions/{offer:code}/{activity}/{submission}/edit', 'SubmissionController@edit')->name('admin.activity.edit')->middleware('can:activity.submission.all.update');
    Route::post('{type:code}/submissions/{offer:code}/{activity}/{submission}/edit', 'SubmissionController@update')->name('admin.activity.update')->middleware('can:activity.submission.all.update');
    Route::get('{type:code}/submissions/{offer:code}/{activity}/{submission}/delete', 'SubmissionController@delete')->name('admin.activity.delete')->middleware('can:activity.submission.all.delete');
    Route::get('{type:code}/submissions/{offer:code}/{activity}/{submission}/destroy', 'SubmissionController@destroy')->name('admin.activity.destroy')->middleware('can:activity.submission.all.delete');
    Route::get('{type:code}/submissions/{offer:code}/{activity}/{submission}', 'SubmissionController@show')->name('admin.activity.show')->middleware('can:activity.submission.all.browse');
    // Activity Submission Rule Check (Dry Run)
    Route::post('{type:code}/submissions/{offer:code}/{activity}/{submission}/check-rules', 'SubmissionRulesController')->name('admin.activity.submission.rule-check')->middleware('can:activity.submission.all.update');
    // Activity Submission Notes
    Route::post('{type:code}/submissions/{offer:code}/{activity}/{submission}/notes', 'SubmissionNotesController')->name('admin.activity.notes.update')->middleware('can:activity.submission.all.update');
    // Activity Submission Value
    Route::post('{type:code}/submissions/{offer:code}/{activity}/{submission}/value', 'SubmissionValueController')->name('admin.activity.value.update')->middleware('can:activity.submission.all.update');
    // Activity Submission Status
    Route::post('{type:code}/submissions/{offer:code}/update-status', 'SubmissionStatusesController')->name('admin.activity.status.update-many')->middleware('can:activity.submission.all.update');
    Route::post('{type:code}/submissions/{offer:code}/{activity}/{submission}/status', 'SubmissionStatusController')->name('admin.activity.status.update')->middleware('can:activity.submission.all.update');

    /* TODO Create new permissions for Activity Type */
    // Activity Type Controller
    Route::any('{type:code}', 'ActivityTypeController@index')->name('admin.activity.type.index')->middleware('can:activity.offer.browse');
    Route::post('{type:code}/export', 'ActivityTypeController@index')->name('admin.activity.type.index.export')->middleware('can:activity.offer.browse');
    Route::any('{type:code}/submissions', 'ActivityTypeController@index')->name('admin.activity.type.show')->middleware('can:activity.offer.browse');
});
