# Changelog

## 1.0.35 - 2023-01-10

### Changes
- Updated admin partials (meta, participant) to display `created_at` datetimes in `'Y-m-d H:i:s'` format. ([WDS-3274](https://brightspot.atlassian.net/browse/WDS-3274))

## 1.0.34 - 2023-01-05

### Changes
- Hotfix for accessing `$submission` entity in `ActivityFormatter`. ([WDS-3396](https://brightspot.atlassian.net/jira/servicedesk/projects/WDS/queues/issue/WDS-3396))

## 1.0.33 - 2022-08-22

### Changes
- Hotfix for changeStatus() passed in user->getKey() vs auth()->user()->getKey() and null. ([WDS-3197](https://brightspot.atlassian.net/browse/WDS-3197))

## 1.0.32 - 2022-08-22

### Changes
- Fixed the reference to the submission_id. ([WDS-3197](https://brightspot.atlassian.net/browse/WDS-3197))
- Updated the changeStatus() and changeValue() to allow for null values when being run from a queue since it does not have access to the default auth()->user(). ([WDS-3197](https://brightspot.atlassian.net/browse/WDS-3197))

## 1.0.31 - 2022-08-11

### Changes
- In some instances where we have migrated data or do not use rules, we will make the Rule Log optional as we won't always have the associated record for the activity. ([WDS-2781](https://brightspot.atlassian.net/browse/WDS-2781))

## 1.0.30 - 2022-07-25

### Changes
- Update ActivitySubmissionTable so that the fields (like id) may not conflict with any joined tables.

## 1.0.29 - 2022-05-30

### Changes
- Update to Activity Status Importer to account for multiple Submissions per Activity

### Upgrading
To ensure the Activity Status Importer is active, include the following lines in your config file. This comes now by default, so you don't need to worry with new sites using the latest module versions. This is also where you can overwrite/extend the ActivityStatusImporter class.

```php
// app\config\activity.php
[
    ...
    'import' => [
        'types' => [
            'activity_status' => [
                'class' => Ignite\Activity\Services\Importers\ActivityStatusImporter::class,
                'label' => 'Activity Status',
                'columns' => ['submission_id', 'user_id', 'status', 'notes']
            ],
        ],
    ],
    ...
]
```

## 1.0.28 - 2022-05-27

### Changes
- [x] Fixed empty status submission on status change

## 1.0.27 - 2022-05-24

### Changes
- Updates for incorporation of the Activity Status Importer into admin backend import section. Added new partial view and ActivityStatusImporter ([WDS-2823](https://brightspot.atlassian.net/browse/WDS-2823))

### Upgrading
To ensure the Activity Status Importer is active, include the following lines in your config file. This comes now by default, so you don't need to worry with new sites using the latest module versions. This is also where you can overwrite/extend the ActivityStatusImporter class. 

```php
// app\config\activity.php
[
    ...
    'import' => [
        'types' => [
            'activity_status' => [
                'class' => Ignite\Activity\Services\Importers\ActivityStatusImporter::class,
                'label' => 'Activity Status',
                'columns' => ['activity_id', 'status']
            ],
        ],
    ],
    ...
]
```

## 1.0.26
- [x] Fixed redirection when clicked on `All` tab on activities index page. The issue is for any program that has
    multiple offers. When clicking on `All` tab from any offer would redirect an user to the all claims page. 

## 1.0.25
- [F] Added some QueryPermissionFilter classes and filtering some tables based on permissions now. See core version
  3.0.30.

## 1.0.24
- [X] `$submission->state` will give you the submission that has the largest ID now when the latest state has the same
  create date as another state. For example if a submission has a "Pending" state, with ID of 10, and "Approved" state,
  with ID of 11. Both were created_at "2022-10-01 03:22:11". We will choose the "Approved" state now for the state
  relationship, because though they both have the latest created_at timestamp, "Approved" has the latest ID.

## 1.0.23
- [X] When you associate a rule to an offer through the seeder, it does not have to have a unique name anymore. A rule
  with the same name can belong to different offers now, and you can have two rules with the same name but different
  metas.

## 1.0.22
- [FB] You cannot pass a `Participant` or an `Authenticatable` to the `ActivitySubmissionRepository` anymore, only a
  User. `changeStatus()` and `changeValue()` were already requiring this via argument type declarations. Only the doc
  blocks needed to be changed for those. So, the two breaking changes are in the `create()` and `update()` methods. If
  you are passing something other than a `\Ignite\Core\Entities\User` to the `$submitter` method for those right now,
  you will need to start passing `User` instance. Also, if you are implementing
  the `\Ignite\Activity\Contracts\ActivitySubmissionRepository` interface, you will need to update your implementation
  to match the new signatures.

## 1.0.21
- [X] Small fix so all methods and events related to `\Ignite\Activity\Contracts\ActivitySubmissionRepository` will
  accept either a Participant or a User. Most places already allowed this and this is what the interface said.

## 1.0.19
- Make sure all the fields you need to edit on your activity data models are fillable.
- When updating submissions your fillable/guard settings on your activity data model(s) will be enforced when
  updating now via the ActivityTypeRepository now. Ignite's base model has this wide open, and prior to this change
  we were using a direct UPDATE on the database, around Eloquent. So, you will only see a change if you have done
  something different on your data model. If you have, just make sure all the fields they need to be able to edit
  are fillable.
