<?php

namespace Ignite\Activity\Events;

use Ignite\Activity\Entities\Activity;
use Ignite\Activity\Entities\Submission;
use Ignite\Core\Contracts\Entities\User;

class ActivitySubmissionUpdated
{
    /**
     * @var Activity
     */
    public $activity;

    /**
     * @var Submission
     */
    public $submission;

    /**
     * @var User
     */
    public $user;

    /**
     * The changes that were made to the submission's data.
     *
     * @var array
     */
    public $changes;

    /**
     * ActivitySubmissionCreated constructor.
     *
     * @param Activity $activity
     * @param Submission $submission
     * @param User $user
     * @param array $changes
     */
    public function __construct(Activity $activity, Submission $submission, User $user, array $changes = [])
    {
        $this->activity = $activity;
        $this->submission = $submission;
        $this->user = $user;
        $this->changes = $changes;
    }
}
