<?php

namespace Ignite\Activity\Listeners;

use Exception;
use Ignite\Activity\Events\ActivitySubmissionCreated;
use Ignite\Core\Audit\Auditor;

class LogSubmissionCreated
{
    /**
     * @var Auditor
     */
    private $auditor;

    /**
     * LogSubmissionCreated constructor.
     *
     * @param Auditor $auditor
     */
    public function __construct(Auditor $auditor)
    {
        $this->auditor = $auditor;
    }

    /**
     * Handle the event.
     *
     * @param ActivitySubmissionCreated $event
     *
     * @throws Exception
     */
    public function handle(ActivitySubmissionCreated $event)
    {
        $this->auditor->audit($event->activity->data, $event->submission, 'created', 'info', '', $event->user);
    }
}
