<?php

namespace Ignite\Activity\Domain\Rules;

use Exception;
use Ignite\Activity\Contracts\Rule as RuleContract;
use Ignite\Activity\Entities\Rule;

class RuleException extends Exception
{
    /**
     * Rule not found exception.
     *
     * @param string $name
     *
     * @return static
     */
    public static function notFound($name)
    {
        return new static(
            "Unregistered rule: $name"
        );
    }

    /**
     * Attempted to create a Rule instance without passing a Rule entity.
     *
     * @param string $name
     * @param array $params
     *
     * @return static
     */
    public static function incorrectParameter($name, $params = [])
    {
        return new static(
            RuleContract::class . ' expects the first parameter to be an instance of ' . Rule::class
        );
    }

    /**
     * Attempted to create a Rule instance without implementing the Rule interface.
     *
     * @param object $instance
     * @param string $name
     *
     * @return static
     */
    public static function missingInterface($instance, $name)
    {
        return new static(
            $name . ": Rule " . get_class($instance) . " must implement " . RuleContract::class
        );
    }
}
