@php
    $transitions = $type->getSchema()->transitions() ?? [];

    $allowedStatuses = [];
    if (! empty($transitions)) {
        foreach ($transitions as $key => $transition) {
            if ($key !== $status && in_array($status, Arr::wrap($transition['from']) ?? [])) {
                $allowedStatuses[$key] = $transition['to'];
            }
        }
    }
@endphp

<div id="submission-status-change-modal" class="modal fade" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <form action="{{ $url }}" method="post" class="form-horizontal">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title">{{ __('Change Status') }}</h4>
                </div>
                <div class="modal-body">
                    {{ csrf_field() }}
                    <div class="form-group">
                        <label class="control-label col-sm-3" for="change-status-from">
                            {{ __('From') }}
                        </label>
                        <div class="col-sm-9">
                            <select id="change-status-from" name="from_display" disabled readonly class="form-control select2">
                                <option value="{{ $status }}">{{ ucwords(str_replace(['_'], ' ', $status)) }}</option>
                            </select>
                            <input type="hidden" name="from" value="{{ $status }}" />
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="control-label col-sm-3" for="change-status-to">
                            {{ __('To') }}
                        </label>
                        <div class="col-sm-9">
                            <select id="change-status-to" name="to" class="form-control select2">
                                <option value="">-- Please choose --</option>
                                @foreach($allowedStatuses as $transition => $state)
                                    <option value="{{ $state }}">{{ ucwords(str_replace(['_'], ' ', $state)) }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="control-label col-sm-3" for="change-status-notes">
                            {{ __('Notes') }}
                        </label>
                        <div class="col-sm-9">
                            <textarea id="change-status-notes" rows="6" class="form-control" name="notes"></textarea>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <input type="hidden" name="submissions" id="submission-status-change-selected" />
                    <button type="button" class="btn btn-default" data-dismiss="modal">{{ __('Cancel') }}</button>
                    <button type="submit" class="btn btn-primary">{{ __('Change') }}</button>
                </div>
            </form>
        </div>
    </div>
</div>
