<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateActivityResourceTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('activity_resource', function (Blueprint $table) {
            $table->id();
            $table->foreignId('type_id')->nullable()->constrained('activity_type')->cascadeOnUpdate();
            $table->foreignId('offer_id')->nullable()->constrained('activity_offer')->cascadeOnUpdate();
            $table->foreignId('activity_id')->nullable()->constrained('activity')->cascadeOnUpdate();
            $table->foreignId('submission_id')->nullable()->constrained('activity_submission')->cascadeOnUpdate()->nullable();
            $table->unsignedInteger('user_id')->nullable();
            $table->json('data');
            $table->json('offer_data');
            $table->json('rule_data');
            $table->timestamps();

            $table->foreign('user_id')
                ->references('user_id')
                ->on('core_user')
                ->onUpdate('cascade')
                ->onDelete('restrict');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('activity_resource');
    }
}
