<?php

// -----

Route::prefix('activity')->middleware('auth')->group(function () {
    Route::get('/{type:code}', 'ActivityTypeController@index')->name('activity.index');
    Route::get('/{type:code}/{offer:code}', 'ActivityTypeController@create')->name('activity.create');
    Route::post('/{type:code}/{offer:code}', 'ActivityTypeController@store')->name('activity.store');
    Route::get('/{type:code}/{offer:code}/{activity:id}', 'ActivityTypeController@show')->name('activity.show');
});

// -----

Route::prefix('admin/activity')->namespace('Admin')->middleware('auth')->group(function () {
    // Activity Offers Controller
    Route::any('{type:code}/offers', 'OfferController@index')->name('admin.offer.index');
    Route::post('{type:code}/offers/export', 'OfferController@index')->name('admin.offer.index.export');
    Route::get('{type:code}/offers/{offer:code}/edit', 'OfferController@edit')->name('admin.offer.edit');
    Route::post('{type:code}/offers/{offer:code}/update', 'OfferController@update')->name('admin.offer.update');

    // -----

    // Activity Notifications Controller
    Route::any('{type:code}/notifications', 'NotificationController@index')->name('admin.notification.index');
    Route::post('{type:code}/notifications/export', 'NotificationController@index')->name('admin.notification.index.export');
    Route::get('{type:code}/notifications/{notification}/edit', 'NotificationController@edit')->name('admin.notification.edit');
    Route::post('{type:code}/notifications/{notification}/update', 'NotificationController@update')->name('admin.notification.update');

    // -----

    // Activity Controller
    Route::any('{type:code}/submissions/{offer:code}', 'SubmissionController@index')->name('admin.activity.index');
    Route::post('{type:code}/submissions/{offer:code}/export', 'SubmissionController@index')->name('admin.activity.index.export');
    Route::get('{type:code}/submissions/{offer:code}/create', 'SubmissionController@create')->name('admin.activity.create');
    Route::post('{type:code}/submissions/{offer:code}/create', 'SubmissionController@store')->name('admin.activity.store');
    Route::get('{type:code}/submissions/{offer:code}/{activity}/{submission}/edit', 'SubmissionController@edit')->name('admin.activity.edit');
    Route::post('{type:code}/submissions/{offer:code}/{activity}/{submission}/edit', 'SubmissionController@update')->name('admin.activity.update');
    Route::get('{type:code}/submissions/{offer:code}/{activity}/{submission}/delete', 'SubmissionController@delete')->name('admin.activity.delete');
    Route::get('{type:code}/submissions/{offer:code}/{activity}/{submission}/destroy', 'SubmissionController@destroy')->name('admin.activity.destroy');
    Route::get('{type:code}/submissions/{offer:code}/{activity}/{submission}', 'SubmissionController@show')->name('admin.activity.show');
    // Activity Submission Rule Check (Dry Run)
    Route::post('{type:code}/submissions/{offer:code}/{activity}/{submission}/check-rules', 'SubmissionRulesController')->name('admin.activity.submission.rule-check');
    // Activity Submission Notes
    Route::post('{type:code}/submissions/{offer:code}/{activity}/{submission}/notes', 'SubmissionNotesController')->name('admin.activity.notes.update');
    // Activity Submission Value
    Route::post('{type:code}/submissions/{offer:code}/{activity}/{submission}/value', 'SubmissionValueController')->name('admin.activity.value.update');
    // Activity Submission Status
    Route::post('{type:code}/submissions/{offer:code}/update-status', 'SubmissionStatusesController')->name('admin.activity.status.update-many');
    Route::post('{type:code}/submissions/{offer:code}/{activity}/{submission}/status', 'SubmissionStatusController')->name('admin.activity.status.update');

    // -----

    // Activity Type Controller
    Route::any('{type:code}', 'ActivityTypeController@index')->name('admin.activity.type.index');
    Route::post('{type:code}/export', 'ActivityTypeController@index')->name('admin.activity.type.index.export');
    Route::any('{type:code}/submissions', 'ActivityTypeController@index')->name('admin.activity.type.show');
});
