<?php

namespace Ignite\Activity\Http\Forms;

use Ignite\Core\Models\Form\Form;

class OfferForm extends Form
{
    public function buildForm()
    {
        $this->add('label', 'text', $this->readOnly([
            'label' => 'Label'
        ]));

        $this->add('code', 'text', $this->readOnly([
            'label' => 'Code'
        ]));

        $this->add('is_redeemable', 'toggle', $this->readOnly([
            'label' => 'Earns points?'
        ]));

        $this->add('status', 'select', $this->field([
            'attr' => ['class' => 'form-control select2'],
            'choices' => $this->model->getStatuses(),
        ]));

        $this->add('sequence', 'number', $this->field([
            'attr' => [
                'class' => 'form-control',
                'min' => 0,
                'step' => 1,
                'max' => 1000
            ],
        ]));

        $count = 0;
        foreach (['en' => 'English', 'es' => 'Spanish'] as $code => $language) {
            $this->add("translations[$code]", 'form', [
                'class' => OfferTranslationForm::class,
                'formOptions' => [
                    'model' => $this->model->translations[$code] ?? [],
                ],
                'data' => [
                    'language' => $code,
                ],
                'wrapper' => [
                    'id' => "tab-{$code}",
                    'class' => 'tab-pane' . ($count === 0 ? ' active' : '')
                ],
                'label_show' => false
            ]);
            $count++;
        }

        $this->add('type_id', 'hidden');

        $this->add('submit', 'submit', $this->field([
            'attr' => ['class' => 'btn btn-primary pull-right'],
            'label' => "Save",
        ]));
    }

    /**
     * Prepare the field data so it remains consistent.
     *
     * @param array $data
     *
     * @return array
     */
    protected function field($data)
    {
        return array_merge_recursive([
            'label_attr' => [
                'class' => 'control-label col-sm-3'
            ],
            'form_horizontal' => true,
        ], $data);
    }

    /**
     * Prepare the field data to be readonly.
     *
     * @param array $data
     *
     * @return array
     */
    protected function readOnly($data)
    {
        return array_merge_recursive([
            'attr' => [
                'readonly' => 'readonly',
                'disabled' => 'disabled'
            ],
        ], $this->field($data));
    }
}