<?php

namespace Ignite\Activity\Events;

use Throwable;
use Ignite\Activity\Entities\Activity;
use Ignite\Activity\Entities\Offer;
use Ignite\Core\Entities\Participant;
use Ignite\Core\Entities\User;
use Illuminate\Contracts\Auth\Authenticatable;
use Illuminate\Support\Fluent;

class ActivitySubmissionFailed
{
    /**
     * @var Throwable
     */
    public $exception;

    /**
     * @var Offer
     */
    public $offer;

    /**
     * @var Fluent
     */
    public $data;

    /**
     * @var Participant|User|Authenticatable
     */
    public $submitter;

    /**
     * @var Activity|null
     */
    public $activity;

    /**
     * ActivitySubmissionFailed constructor.
     *
     * @param Throwable $exception
     * @param Offer $offer
     * @param Fluent $data
     * @param User $submitter
     * @param Activity|null $activity
     */
    public function __construct(Throwable $exception, Offer $offer, Fluent $data, $submitter, Activity $activity = null)
    {
        $this->offer = $offer;
        $this->data = $data;
        $this->submitter = $submitter;
        $this->exception = $exception;
        $this->activity = $activity;
    }
}
