<?php

namespace Ignite\Activity\Domain\Schema;

use Exception;
use Facade\IgnitionContracts\ProvidesSolution;
use Facade\IgnitionContracts\Solution;
use Ignite\Activity\Solutions\SchemaFileNotFoundSolution;
use Throwable;

class SchemaNotFoundException extends Exception implements ProvidesSolution
{
    /**
     * @var string
     */
    protected $type;

    /**
     * SchemaNotFoundException constructor.
     *
     * @param $type
     * @param int $code
     * @param Throwable|null $previous
     */
    public function __construct($type, $code = 0, Throwable $previous = null)
    {
        $this->type = $type;

        parent::__construct("Missing schema for {$type}", $code, $previous);
    }

    /**
     * The solution instance to be used with Ignition.
     *
     * @return Solution
     */
    public function getSolution(): Solution
    {
        return app(SchemaFileNotFoundSolution::class)->setType($this->type);
    }
}
