<?php

/** @var \Illuminate\Database\Eloquent\Factory $factory */

use Faker\Generator as Faker;
use Ignite\Activity\Entities\Activity;
use Ignite\Activity\Entities\Offer;
use Ignite\Activity\Entities\Submission;
use Ignite\Activity\Entities\Resource;
use Ignite\Activity\Entities\Type;
use Ignite\Core\Entities\User;

$factory->define(Resource::class, function (Faker $faker) {
    return [
        'type_id' => factory(Type::class),
        'offer_id' => factory(Offer::class),
        'user_id' => factory(User::class),
        'activity_id' => factory(Activity::class),
        'submission_id' => factory(Submission::class),
        'data' => [
            'first' => $faker->firstName,
            'last' => $faker->lastName,
            'email' => $faker->safeEmail,
        ],
        'offer_data' => [],
        'rule_data' => [],
    ];
});
