<?php

namespace Ignite\Activity\Events;

use Ignite\Activity\Entities\Activity;
use Ignite\Activity\Entities\Submission;
use Ignite\Core\Contracts\Entities\Participant;
use Ignite\Core\Contracts\Entities\User;
use Illuminate\Contracts\Auth\Authenticatable;

class ActivitySubmissionUpdated
{
    /**
     * @var Activity
     */
    public $activity;

    /**
     * @var Submission
     */
    public $submission;

    /**
     * @var User
     */
    public $user;

    /**
     * The changes that were made to the submission's data.
     *
     * @var array
     */
    public $changes;

    /**
     * ActivitySubmissionCreated constructor.
     *
     * @param Activity $activity
     * @param Submission $submission
     * @param \Ignite\Core\Entities\User|Participant|Authenticatable $user
     * @param array $changes
     */
    public function __construct(Activity $activity, Submission $submission, $user, array $changes = [])
    {
        $this->activity = $activity;
        $this->submission = $submission;
        $this->user = $user;
        $this->changes = $changes;
    }
}
