<?php

namespace Ignite\Activity\Providers;

use Ignite\Activity\Events\ActivitySubmissionCreated;
use Ignite\Activity\Events\ActivitySubmissionUpdated;
use Ignite\Activity\Listeners\AdminMenu;
use Ignite\Activity\Listeners\ActivityNavigationMenu;
use Ignite\Activity\Listeners\LogSubmissionCreated;
use Ignite\Activity\Listeners\ProcessRules;
use Ignite\Core\Events\Menus\AdminMenuPreCompile;
use Ignite\Core\Events\Menus\NavigationMenuPreCompile;
use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;

class EventServiceProvider extends ServiceProvider
{
    /**
     * The event listener mappings for the application.
     *
     * @var array
     */
    protected $listen = [
        AdminMenuPreCompile::class => [
            AdminMenu::class
        ],
        NavigationMenuPreCompile::class => [
            ActivityNavigationMenu::class
        ],
        ActivitySubmissionCreated::class => [
            LogSubmissionCreated::class,
            ProcessRules::class,
        ],
        ActivitySubmissionUpdated::class => [
            ProcessRules::class
        ]
    ];

    /**
     * The subscriber classes to register.
     *
     * @var array
     */
    protected $subscribe = [];
}
