<?php

namespace Ignite\Activity\Domain\Schema;

use Exception;
use Facade\IgnitionContracts\ProvidesSolution;
use Facade\IgnitionContracts\Solution;
use Ignite\Activity\Solutions\SchemaFileNotConfiguredSolution;
use Throwable;

class SchemaNotConfiguredException extends Exception implements ProvidesSolution
{
    /**
     * @var string
     */
    protected $type;

    /**
     * SchemaNotFoundException constructor.
     *
     * @param $type
     * @param int $code
     * @param Throwable|null $previous
     */
    public function __construct($type, $code = 0, Throwable $previous = null)
    {
        $this->type = $type;

        parent::__construct("Schema {$type} is not configured", $code, $previous);
    }

    /**
     * The solution instance to be used with Ignition.
     *
     * @return Solution
     */
    public function getSolution(): Solution
    {
        return app(SchemaFileNotConfiguredSolution::class)->setType($this->type);
    }
}
