<?php

namespace Ignite\Activity\Http\Controllers\Admin;

use Exception;
use Ignite\Activity\Contracts\ActivitySubmissionRepository;
use Ignite\Activity\Entities\Activity;
use Ignite\Activity\Entities\Offer;
use Ignite\Activity\Entities\Submission;
use Ignite\Activity\Entities\Type;
use Ignite\Core\Http\Controllers\Controller;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class SubmissionStatusesController extends Controller
{
    /**
     * @var ActivitySubmissionRepository
     */
    protected ActivitySubmissionRepository $repository;

    /**
     * SubmissionStatusesController constructor.
     *
     * @param ActivitySubmissionRepository $repository
     */
    public function __construct(ActivitySubmissionRepository $repository)
    {
        $this->repository = $repository;
    }

    /**
     * Update many activity statuses.
     *
     * @param Type $type
     * @param Offer $offer
     * @param Request $request
     *
     * @return Renderable|RedirectResponse
     */
    public function __invoke(Type $type, Offer $offer, Request $request)
    {
        $from = $request->get('from');
        $to = $request->get('to');
        $submissionIds = explode(',', $request->get('submissions'));
        $notes = $request->get('notes');

        app('db')->beginTransaction();

        try {
            foreach ($submissionIds as $id) {
                $this->repository->changeStatus($id, $to, $notes);
            }

            app('db')->commit();

            $this->flashSuccess(sprintf(
                "%s %s were been updated from %s to %s.",
                $count = count($submissionIds),
                Str::plural('submission', $count),
                $from,
                $to
            ));
        } catch (Exception $exception) {
            app('db')->rollBack();

            logger()->critical($exception->getMessage(), compact('exception'));

            $this->flashError('An error has occurred. IT have been notified. Statuses have not been changed.');
        }

        return redirect()->route('admin.activity.index', compact('type', 'offer'));
    }
}
