<?php

namespace Ignite\Activity\Contracts;

use Ignite\Activity\Domain\Submissions\ActivitySubmissionException;
use Ignite\Activity\Entities\Activity;
use Ignite\Activity\Entities\Offer;
use Ignite\Core\Contracts\Entities\Participant;
use Ignite\Core\Entities\User;
use Illuminate\Contracts\Auth\Authenticatable;

interface ActivitySubmissionRepository
{
    /**
     * Create a new activity submission.
     *
     * @param Offer $offer
     * @param array $data
     * @param User|Participant|Authenticatable $submitter
     *
     * @return Activity
     * @throws ActivitySubmissionException
     */
    public function create(Offer $offer, array $data, $submitter);

    /**
     * Create an existing activity submission.
     *
     * @param int $submissionId
     * @param array $data
     * @param User|Participant|Authenticatable $user
     *
     * @return Activity
     * @throws ActivitySubmissionException
     */
    public function update($submissionId, array $data, $user);

    /**
     * Change the status of the submission.
     *
     * @param int $submissionId
     * @param string $status
     * @param string|null $notes
     * @param User|Participant|Authenticatable|null $user
     *
     * @return bool
     * @throws ActivitySubmissionException
     */
    public function changeStatus($submissionId, string $status, string $notes = null, User $user = null);

    /**
     * Change the value of the submission.
     *
     * @param int $submissionId
     * @param int|float $value
     * @param User|Participant|Authenticatable|null $user
     * @param bool $isManual
     *
     * @return bool
     * @throws ActivitySubmissionException
     */
    public function changeValue($submissionId, $value, User $user = null, bool $isManual = false);
}