<?php

namespace Ignite\Activity\Events;

use Ignite\Activity\Entities\Activity;
use Ignite\Activity\Entities\Submission;
use Ignite\Core\Contracts\Entities\User;

class ActivitySubmissionUpdated
{
    /**
     * @var Activity
     */
    public $activity;

    /**
     * @var Submission
     */
    public $submission;

    /**
     * @var User
     */
    public $user;

    /**
     * ActivitySubmissionCreated constructor.
     *
     * @param Activity $activity
     * @param Submission $submission
     * @param User $user
     */
    public function __construct(Activity $activity, Submission $submission, User $user)
    {
        $this->activity = $activity;
        $this->submission = $submission;
        $this->user = $user;
    }
}
