<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class UpdateActivitySubmissionStatusTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (Schema::hasColumn('activity_submission_status', 'user_id')) {
            Schema::table('activity_submission_status', function (Blueprint $table) {
                $table->dropForeign('user_id');

                $table->renameColumn('user_id', 'changed_by_user_id');
                $table->foreign('changed_by_user_id')
                    ->references('changed_by_user_id')
                    ->on('core_user')
                    ->onUpdate('cascade');
            });
        } else {
            Schema::table('activity_submission_status', function (Blueprint $table) {
                $table->unsignedInteger('changed_by_user_id')->nullable()->after('submission_id');

                $table->foreign('changed_by_user_id')
                    ->references('user_id')
                    ->on('core_user')
                    ->onUpdate('cascade');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('activity_submission_status', function (Blueprint $table) {
            $table->dropForeign('changed_by_user_id');

            $table->renameColumn('changed_by_user_id', 'user_id');
            $table->foreign('user_id')
                ->references('user_id')
                ->on('core_user')
                ->onUpdate('cascade');
        });
    }
}
