<?php

namespace Ignite\Activity\Events;

use Ignite\Activity\Entities\Submission;
use Ignite\Core\Contracts\Entities\Participant;
use Ignite\Core\Entities\User;
use Illuminate\Contracts\Auth\Authenticatable;

class ActivitySubmissionValueChanged
{
    /**
     * @var Submission
     */
    public $submission;

    /**
     * @var int|float
     */
    public $value;

    /**
     * @var User|Participant|Authenticatable|null
     */
    public $changedByUser;

    /**
     * ActivitySubmissionStatusChanged constructor.
     *
     * @param Submission $submission
     * @param int|float $value
     * @param User|Participant|Authenticatable|null $changedByUser
     */
    public function __construct(Submission $submission, $value, $changedByUser)
    {
        $this->submission = $submission;
        $this->value = $value;
        $this->changedByUser = $changedByUser;
    }
}
