<div class="timeline-container">
{{-- $states is provided via /admin/submissions/edit.blade.php --}}
@php
$stateGroups = $submission->states->groupBy(function ($model) {
    return $model->created_at->format('F jS, Y');
});
@endphp
    <h4 class="card-title">{{ __('Status History') }}</h4>
    <hr />
    <ul class="timeline">
    @foreach ($stateGroups as $date => $stateGroup)
        <li class="time-label">
            <span class="bg-white" style="border: 3px solid #dadada">{{ $date }}</span>
        </li>
        @foreach ($stateGroup as $state)
        <li>
            @if (isset($states[$state->label]))
            <i class="fa fa-{{ $states[$state->label]['icon'] }} bg-{{ $states[$state->label]['color'] }}"></i>
            <div class="timeline-item">
                <span class="time"><i class="fa fa-clock-o"></i> {{ $state->created_at->format('g:ia') }}</span>
                <h4 class="timeline-header">{{ $state->friendlyLabel() }}</h4>
                @if ($state->notes)
                <div class="timeline-body">
                    {!! $state->notes !!}
                </div>
                @endif
            </div>
            @else
                <i class="fa fa-exclamation-triangle bg-gray"></i>
                <div class="timeline-item">
                    <h4 class="timeline-header">Unknown status: {{ $state->friendlyLabel() }}</h4>
                </div>
            @endif
        </li>
        @endforeach
    @endforeach
        <li>
            <i class="fa fa-clock-o bg-gray"></i>
        </li>
    </ul>
</div>