<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class UpdateActivityTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (Schema::hasColumn('activity', 'submitter_id')) {
            Schema::table('activity', function (Blueprint $table) {
                $table->dropForeign('submitter_id');

                $table->renameColumn('submitter_id', 'submitted_by_user_id');
                $table->foreign('submitted_by_user_id')
                    ->references('user_id')
                    ->on('core_user')
                    ->onUpdate('cascade')
                    ->onDelete('restrict');
            });
        } else {
            Schema::table('activity', function (Blueprint $table) {
                $table->unsignedInteger('submitted_by_user_id')->nullable()->after('offer_id');

                $table->foreign('submitted_by_user_id')
                    ->references('user_id')
                    ->on('core_user')
                    ->onUpdate('cascade')
                    ->onDelete('restrict');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('activity', function (Blueprint $table) {
            $table->dropForeign('submitted_by_user_id');

            $table->renameColumn('submitted_by_user_id', 'submitter_id');
            $table->foreign('submitter_id')
                ->references('user_id')
                ->on('core_user')
                ->onUpdate('cascade')
                ->onDelete('restrict');
        });
    }
}
