<?php

/** @var \Illuminate\Database\Eloquent\Factory $factory */

use Faker\Generator as Faker;
use Ignite\Activity\Contracts\OfferForm;
use Ignite\Activity\Domain\Schema\Schema;
use Ignite\Activity\Domain\Offers\OfferFormFactory;
use Ignite\Activity\Entities\Type;
use Ignite\Theme\Manager;
use Ignite\Theme\Theme;
use Illuminate\Support\Str;

$factory->define(Type::class, function (Faker $faker) {
    $label = $faker->unique()->sentence(4);
    $code = Str::slug($label, '-');

    return [
        'label' => $label,
        'code' => $code,
        'meta' => [],
    ];
});
