<?php

namespace Ignite\Activity\Models\Grid;

use Ignite\Activity\Entities\Notification;
use Ignite\Core\Models\Grid\EloquentTable;
use Illuminate\Database\DatabaseManager;
use Yajra\DataTables\DataTables;

class ActivityNotificationTable extends EloquentTable
{
    //use ReportFormConfiguration;

    /**
     * The columns that should always be displayed when using the ReportFormConfiguration trait.
     * @var array
     */
    protected $alwaysDisplay = [
        'action', 'sequence', 'label', 'code', 'status', 'created_at'
    ];

    /**
     * @var OfferFormatter
     */
    protected $formatter;

    /**
     * ParticipantTable constructor.
     *
     * @param DataTables $datatables
     * @param DatabaseManager $databaseManager
     * @param OfferFormatter $formatter
     * @param array $params
     */
    public function __construct(
        DataTables $datatables,
        DatabaseManager $databaseManager,
        OfferFormatter $formatter,
        array $params = []
    ) {
        parent::__construct($datatables, $databaseManager, $params);

        $this->formatter = $formatter;
    }

    /**
     * The columns to show.
     *
     * @return array
     */
    public function columns()
    {
        return [
            'action' => [
                'name' => 'actions',
                'title' => 'Actions',
                'searchable' => false,
                'orderable' => false,
                'exportable' => false,
                'printable' => false,
                'visible' => true,
                'width' => '80px',
                'class' => 'actions'
            ],
            'sequence' => [
                'title' => 'Sequence',
                'name' => 'activity_offer.sequence',
                'orderable' => true,
                'exportable' => true,
            ],
            'created_at' => [
                'title' => 'Date',
                'name' => 'activity_offer.created_at',
                'orderable' => true,
                'exportable' => true,
            ],
            'label' => [
                'title' => 'Label',
                'name' => 'activity_offer.label',
                'orderable' => true,
                'exportable' => true,
            ],
            'code' => [
                'title' => 'Code',
                'name' => 'activity_offer.code',
                'orderable' => true,
                'exportable' => true,
            ],
            'is_redeemable' => [
                'title' => 'Earns points?',
                'name' => 'activity_offer.is_redeemable',
                'orderable' => true,
                'exportable' => true,
            ],
            'status' => [
                'title' => 'Status',
                'name' => 'activity_offer.status',
                'orderable' => true,
                'exportable' => true,
            ],
        ];
    }

    /**
     * The participants query.
     *
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function query()
    {
        $columns = collect($this->getColumns())
            ->keyBy('name')
            ->except('actions')
            ->keys()
            ->toArray();

        return Offer::query()
            ->with(['type', 'rules'])
            //->select($columns)
            ->where('type_id', $this->type->getKey())
            ->when($this->status, function ($q) {
                $q->where('status', $this->status);
            });
    }

    /**
     * Get a map of column keys => functions to format columns.
     *
     * @return array
     */
    protected function getColumnFormattingMap()
    {
        return [
            'action' => [$this->formatter, 'actions'],
            'sequence' => [$this->formatter, 'sequence'],
            'type_id' => [$this->formatter, 'type'],
            'status' => [$this->formatter, 'status'],
            'is_redeemable' => [$this->formatter, 'isRedeemable'],
            'created_at' => [$this->formatter, 'createdAt'],
        ];
    }

    /**
     * Get default builder parameters.
     *
     * @return array
     */
    protected function getBuilderParameters()
    {
        $params = func_get_args();

        return parent::getBuilderParameters(array_merge([
            'buttons' => [
                'pageLength',
            ],
            'order' => [[1, 'asc']]
        ], ...$params));
    }
}
