<?php

namespace Ignite\Activity\Listeners;

use Ignite\Activity\Entities\Type;
use Ignite\Core\Events\Menus\NavigationMenuPreCompile;
use Ignite\Core\Events\Menus\UserMenuPreCompile;
use Ignite\Core\Models\Menu\Item;
use Ignite\Core\Models\Menu\NavigationMenu;
use Illuminate\Contracts\Auth\StatefulGuard;
use Nwidart\Modules\Laravel\LaravelFileRepository as ModuleRepository;

class ActivityNavigationMenu
{
    /**
     * @var ModuleRepository
     */
    private $moduleRepository;

    /**
     * AddCatalogItemsToNavigationMenu constructor.
     *
     * @param ModuleRepository $moduleRepository
     */
    public function __construct(ModuleRepository $moduleRepository)
    {
        $this->moduleRepository = $moduleRepository;
    }

    /**
     * Handle the event.
     *
     * @param NavigationMenuPreCompile|UserMenuPreCompile $event
     * @throws \Nwidart\Modules\Exceptions\ModuleNotFoundException
     */
    public function handle($event)
    {
        if ($this->moduleRepository->isDisabled('Activity') || auth()->guest()) {
            return;
        }

        /** @var NavigationMenu $manager */
        $manager = $event->getManager();

        $types = Type::query()->with('offers')->has('offers', '>', 0)->get();
        $children = [];

        if ($types->count() === 1) {
            $top = $this->createSubmitItem("/activity/{$types->first()->code}");
        } else {
            /** @var Type $type */
            foreach ($types as $index => $type) {
                // TODO: Add an isVisible() method to the Offer model
                // TODO: Add a custom collection for Offer models
                //if ($type->offers->hasOneVisibleOffer()) {
                    $children[] = app(Item::class, [
                        'label' => $type->plural(),
                        'url' => "/activity/{$type->code}",
                        'position' => ($index + 1),
                        'allow' => true,
                        'children' => []
                    ]);
                //}
            }
            $top = $this->createSubmitItem('/activity', 'Submit', 10, true, $children);
        }

        $manager->add($top);
    }

    /**
     * Create the submit item.
     *
     * @param $url
     * @param string $label
     * @param int $position
     * @param bool $allow
     * @param array $children
     *
     * @return Item
     */
    protected function createSubmitItem($url = '/activity', $label = 'Submit', $position = 10, $allow = true, $children = [])
    {
        return app(Item::class, compact('url', 'label', 'position', 'allow', 'children'));
    }
}
