@php
// Get the states as an array instead of with getState() to avoid an exception being thrown when the state doesn't exist
$stateMachineStates = $submission->stateMachine()->getStates();
@endphp
@if (isset($stateMachineStates[$submission->status]))
@php
    $transitions = $submission->stateMachine()->getState($submission->status)->transitions() ?? [];
    $allowedStatuses = [];
    if (! empty($transitions)) {
        foreach ($transitions as $status => $transition) {
            if ($status !== $submission->status) {
                $allowedStatuses[$transition->state()] = array_merge(
                    $states[$transition->state()],
                    ['action' => $transition->label()]
                );
            }
        }
    }
@endphp
    @if (! empty($allowedStatuses))
    <div class="form-group">
        <div class="btn-group">
            @foreach ($allowedStatuses as $status)
                <a x-data="changeStatus()" x-init="status='{{ $status['name'] }}'; id={{ $submission->getKey() }};" @click.prevent="change" class="btn btn-default" href="{{ route('admin.activity.status.update', array_merge(compact('type', 'offer', 'activity', 'submission'), ['status' => $status['name']])) }}">
                    <span class="fa fa-{{ $status['icon'] }} text-{{ $status['color'] }}"></span>
                    {{ Str::title($status['action']) }}
                </a>
            @endforeach
        </div>
    </div>
    @endif
@else
    <p>Unknown state: {{ $submission->statusLabel() }}</p>
@endif

@include('Activity::admin.submissions.partials.change-status', [
    'url' => route('admin.activity.status.update', [
        'type' => $type->code,
        'offer' => $offer->code,
        'activity' => $activity->getKey(),
        'submission' => $submission->getKey(),
    ]),
    'type' => $type,
    'status' => $submission->status
])

@push('js')
    <script>
        function changeStatus() {
            return {
                id: null,
                status: null,
                change: function () {
                    $('#change-status-to').val(this.status).trigger('change');
                    $('#change-status-value').val(this.status);
                    $('#submission-status-change-selected').val(this.id);
                    $('#submission-status-change-modal').modal('show');
                }
            };
        }
    </script>
@endpush