<?php

namespace Ignite\Activity\Traits;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

trait SluggableTrait
{
    /**
     * Boot the sluggable trait so that it listens on saving an eloquent model.
     *
     * @return void
     */
    public static function bootSluggableTrait()
    {
        static::saving(function (Model $model) {
            if (property_exists($model, 'sluggables') && ! empty($sluggables = $model->sluggables)) {
                foreach ($sluggables as $sluggable => $attribute) {
                    if (empty($value = $model->getAttribute($sluggable))) {
                        $model->setAttribute(
                            $sluggable,
                            Str::slug($model->getAttribute($attribute), '-')
                        );
                    }
                }
            }
        });
    }
}
