<?php

namespace Ignite\Activity\Listeners;

use Exception;
use Ignite\Activity\Contracts\ActivitySubmissionRepository;
use Ignite\Activity\Domain\Rules\RuleChannel;
use Ignite\Activity\Domain\Rules\RuleManager;
use Ignite\Activity\Domain\Rules\RuleProcessor;
use Ignite\Activity\Events\ActivitySubmissionCreated;
use Ignite\Activity\Events\ActivitySubmissionUpdated;
use Illuminate\Contracts\Queue\ShouldQueue;

class ProcessRules
{
    /**
     * @var RuleProcessor
     */
    protected $processor;

    /**
     * @var ActivitySubmissionRepository
     */
    protected $submissionRepository;

    /**
     * ProcessRules constructor.
     *
     * @param RuleProcessor $processor
     * @param ActivitySubmissionRepository $submissionRepository
     */
    public function __construct(RuleProcessor $processor, ActivitySubmissionRepository $submissionRepository)
    {
        $this->processor = $processor;
        $this->submissionRepository = $submissionRepository;
    }

    /**
     * Handle the event.
     *
     * @param ActivitySubmissionCreated|ActivitySubmissionUpdated $event
     *
     * @throws Exception
     */
    public function handle($event)
    {
        $manager = $this->processor->process($event->activity, $event->submission);

        if ($manager->hasChangedValue()) {
            $this->submissionRepository->changeValue(
                $event->submission->getKey(),
                $manager->value(),
                $event->user ?? $event->submission->user,
                $isManual = false
            );
        }
    }
}
