<?php

namespace Ignite\Activity\Domain\Schema;

use Exception;
use Throwable;

class SchemaFieldNotFoundException extends Exception
{
    /**
     * @var string
     */
    private $name;

    /**
     * @var array
     */
    private $fields;

    /**
     * SchemaFieldNotFoundException constructor.
     *
     * @param $name
     * @param $fields
     * @param int $code
     * @param Throwable|null $previous
     */
    public function __construct($name, $fields, $code = 0, Throwable $previous = null)
    {
        $this->name = $name;
        $this->fields = $fields;

        $fieldJson = json_encode($fields, JSON_PRETTY_PRINT);

        parent::__construct("{$name} field was not found in {$fieldJson}", $code, $previous);
    }
}