<?php

namespace Ignite\Activity\Tests\Unit;

use Ignite\Activity\Providers\RouteServiceProvider;
use Ignite\Activity\Tests\TestCase;
use Illuminate\Routing\Route;

class RouteServiceProviderTest extends TestCase
{
    /**
     * @test
     */
    public function it_defines_the_correct_route_namespace_for_web()
    {
        $provider = new RouteServiceProvider($this->app);

        $provider->map();

        /** @var \Illuminate\Routing\RouteCollection $routes */
        $routes = $this->app['router']->getRoutes();

        $nameList = $routes->getRoutesByName();

        $key = 'admin.activity.type.index';

        $this->assertArrayHasKey($key, $nameList);

        $this->assertInstanceOf(Route::class, $nameList[$key]);

        $this->assertEquals(
            'Ignite\Activity\Http\Controllers\Admin',
            $nameList[$key]->getAction('namespace')
        );
    }

    /**
     * @test
     */
    public function it_defines_a_route_for_activity_types()
    {
        /** @var \Illuminate\Routing\RouteCollection $routes */
        $routes = $this->app['router']->getRoutes();

        $nameList = $routes->getRoutesByName();

        $key = 'admin.activity.type.index';

        $this->assertArrayHasKey($key, $nameList);
        $this->assertInstanceOf(Route::class, $route = $nameList[$key]);
        $this->assertEquals('Ignite\Activity\Http\Controllers\Admin', $route->getAction('namespace'));
        $this->assertContains('auth', $route->getAction('middleware'));
        $this->assertContains('web', $route->getAction('middleware'));
        $this->assertEquals($key, $route->getAction('as'));
        $this->assertEquals('/admin/activity', $route->getAction('prefix'));
        $this->assertEquals('admin/activity/{type}', $route->uri());
    }
}
