<?php

namespace Ignite\Activity\Events;

use Ignite\Activity\Entities\Offer;
use Ignite\Core\Entities\Participant;
use Ignite\Core\Entities\User;
use Illuminate\Contracts\Auth\Authenticatable;
use Illuminate\Support\Fluent;

class ActivitySubmissionCreating
{
    /**
     * @var Offer
     */
    public $offer;

    /**
     * @var Fluent
     */
    public $data;

    /**
     * @var Participant|User|Authenticatable
     */
    public $submitter;

    /**
     * ActivitySubmissionCreating constructor.
     *
     * @param Offer $offer
     * @param Fluent $data
     * @param Authenticatable|User|Participant $submitter
     */
    public function __construct(Offer $offer, Fluent $data, $submitter)
    {
        $this->offer = $offer;
        $this->data = $data;
        $this->submitter = $submitter;
    }
}
