<?php

namespace Ignite\Activity\Models\Form;

use Ignite\Activity\Contracts\Schema;
use Ignite\Activity\Domain\Schema\Fields;
use Ignite\Activity\Entities\Offer;
use Ignite\Activity\Entities\Type;
use Ignite\Core\Models\Form\Form;
use Illuminate\Support\Arr;

class ActivityForm extends Form
{
    /**
     * Create the form fields from the given schema.
     *
     * @return void
     */
    protected function fromSchema()
    {
        $this->setFormOptions([
            'class' => 'form-horizontal',
            'method' => 'POST',
            'novalidate'
        ]);

        foreach ($this->getSchemaFields() as $field) {
            if (isset($field['internal']) && $field['internal'] === true) {
                if (! $this->isViewingBackend()) {
                    continue;
                }
            }

            if ($this->getData('readonly', false)) {
                Arr::set($field, 'readonly', true);
                Arr::set($field, 'attr.readonly', true);
                Arr::set($field, 'attr.disabled', true);
            }

            $this->renderField($field);
        }

        if (! $this->getData('readonly')) {
            $this->add('submit', 'submit', $this->getSubmitButtonConfig());
        }
    }

    /**
     * The associated offer.
     *
     * @return Offer
     */
    protected function getOffer()
    {
        return $this->getData('offer');
    }

    /**
     * The associated type.
     *
     * @return Type
     */
    protected function getType()
    {
        return $this->getOffer()->type;
    }

    /**
     * The schema for the associated type.
     *
     * @return Schema
     */
    protected function getSchema()
    {
        return $this->getType()->getSchema();
    }

    /**
     * The schema fields to add to the form.
     *
     * @return array
     */
    protected function getSchemaFields()
    {
        $fields = $this->getSchema()->fields();

        if (method_exists($this, 'fields')) {
            $fields = collect($this->fields($this->getSchemaFieldCollection($fields)))
                ->map(function ($field) {
                    return $field->toArray();
                })->toArray();
        }

        return $fields;
    }

    /**
     * The hydrated fields collection instance.
     *
     * @param array $fields
     *
     * @return Fields
     */
    protected function getSchemaFieldCollection(array $fields)
    {
        return app(Fields::class, compact('fields'));
    }

    /**
     * The config options for the config button.
     *
     * @return array
     */
    protected function getSubmitButtonConfig()
    {
        return [
            "label" => "Submit",
            "attr" => [
                "id" => "submit-offer",
                "class" => "btn btn-primary pl-4 pr-4"
            ],
            "wrapper" => [
                "class" => "form-button text-right"
            ]
        ];
    }
}
