<?php

namespace Ignite\Activity\Listeners;

use Ignite\Activity\Entities\Offer;
use Ignite\Activity\Entities\Type;
use Ignite\Core\Events\Menus\AdminMenuPreCompile;
use Ignite\Core\Models\Menu\Item;
use Nwidart\Modules\Facades\Module;

class AdminMenu
{
    /**
     * Handle the event.
     *
     * @param AdminMenuPreCompile $event
     * @return void
     */
    public function handle(AdminMenuPreCompile $event)
    {
        if (! Module::isEnabled('Activity')) {
            return;
        }

        $types = Type::query()->get()->map(function ($type, $index) {
            return $this->getItemFor($type, $index);
        });

        $item = app(Item::class, [
            'url' => '#',
            'label' => 'Activities',
            'position' => 25,
            'allow' => 'admin.activity.browse',
            'children' => $types,
            'icon' => 'heartbeat'
        ]);

        $event->getManager()->add($item);
    }

    /**
     * Get a menu item for a type.
     *
     * @param Type $type
     * @param int $index
     *
     * @return Item
     */
    protected function getItemFor($type, $index)
    {
        $position = ($index + 1) * 100;

        return app(Item::class, [
            'url' => route('admin.activity.type.index', ['type' => $type->code]),
            'label' => $type->plural(),
            'position' => $position,
            'allow' => "admin.program.{$type->code}.browse",
            'children' => [
                app(Item::class, [
                    'url' => route('admin.activity.type.show', ['type' => $type->code]),
                    'label' => 'Submissions',
                    'position' => $position + 1,
                    'allow' => "admin.program.{$type->code}.browse",
                    'children' => $this->getOffersFor($type),
                    'icon' => 'database'
                ]),
                app(Item::class, [
                    'url' => url("/admin/activity/{$type->code}/offers"),
                    'label' => 'Offers',
                    'position' => $position + 2,
                    'allow' => "admin.program.{$type->code}.browse",
                    'children' => [],
                    'icon' => 'tag'
                ]),
//                app(Item::class, [
//                    'url' => url("/admin/activity/{$type->code}/notifications"),
//                    'label' => 'Notifications',
//                    'position' => $position + 3,
//                    'allow' => "admin.program.{$type->code}.browse",
//                    'children' => [],
//                    'icon' => 'bell'
//                ])
            ],
            'icon' => 'table'
        ]);
    }

    protected function getOffersFor($type)
    {
        $children = [];

        /** @var Offer $offer */
        foreach ($type->offers as $offer) {
            $children[] = app(Item::class, [
                'url' => route('admin.activity.index', ['type' => $type->code, 'offer' => $offer->code]),
                'label' => $offer->label(),
                'position' => $offer->sequence,
                'allow' => "admin.program.{$type->code}.browse",
                'children' => [],
                'icon' => 'tag'
            ]);
        }

        return $children;
    }
}
